'
' This is the base class for all classes that are used to model a kind
' of security zone.
'
Public MustInherit Class SecurityZone
    Implements ISecurityZone
    Private myParent As SecurityZone = Nothing

    '
    ' Return this object's parent zone.
    '
    Public ReadOnly Property Parent() As SecurityZone
        Get
            Return myParent
        End Get
    End Property
    '
    ' This method is called to notify this security zone of a change in
    ' a sensor measurement.
    '
    ' measurement - The new measurement
    ' mySensor - The object that models the sensor that produced 
    '            the measurement.
    '
    Public Sub Notify(ByVal measurement As Integer, ByVal mySensor As Sensor) _
    Implements ISecurityZone.Notify
        If Not HandleNotification(measurement, mySensor) And myParent IsNot Nothing Then
            myParent.Notify(measurement, mySensor)
        End If
    End Sub 'Notify

    '
    ' This method is called by the notify method so that this
    ' object can have a chance to handle measurements.
    '
    Public MustOverride Function HandleNotification(ByVal measurement As Integer, ByVal sensor As Sensor) As Boolean

    '
    ' This method is called by a child zone to report a fire.  It is
    ' expected that the child zone has turned on sprinklers or taken
    ' other appropriate measures to control the fire within the child
    ' zone. The purpose of this method is to be overridden by other
    ' subclasses so that it can take any necessary actions outside of
    ' the child zone.
    '
    Public Overridable Sub FireAlarm(ByVal zone As SecurityZone) _
    Implements ISecurityZone.FireAlarm
        ' Turn on sprinklers
        '...
        If myParent IsNot Nothing Then
            myParent.FireAlarm(zone)
        End If
    End Sub 'FireAlarm 
End Class 'SecurityZone